/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.server;

import filenet.pe.peorb.client.ORBSession;
import filenet.pe.soap.SOAPClientSession;
import filenet.vw.api.VWException;
import filenet.vw.base.VWTokenHelper;
import filenet.vw.base.logging.Logger;
import filenet.vw.server.IPECommands;
import filenet.vw.soap.VWSOAPRouterURL;

public class PECommandsFactory {
    static final String m_className = "PECommandsFactory";
    protected static Logger logger = Logger.getLogger("filenet.vw.server");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getShortName(String name) {
        int i;
        String userPrefix;
        String res;
        block8: {
            if (name == null) {
                return null;
            }
            res = name;
            try {
                userPrefix = "CN=";
                i = name.indexOf(userPrefix);
                if (i == -1) {
                    userPrefix = "uid=";
                    i = name.indexOf(userPrefix);
                }
                if (i != -1) break block8;
                String string = res;
                Object var7_6 = null;
                if (logger.isFinest()) {
                    logger.finest(m_className, "getShortName", "orig=" + name + ", new=" + res);
                }
                return string;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var7_8 = null;
                    if (!logger.isFinest()) break block9;
                    logger.finest(m_className, "getShortName", "orig=" + name + ", new=" + res);
                }
                throw throwable;
            }
        }
        int j = name.indexOf(",");
        if (j == -1) {
            j = name.length();
        }
        String string = res = name.substring(i + userPrefix.length(), j);
        Object var7_7 = null;
        if (logger.isFinest()) {
            logger.finest(m_className, "getShortName", "orig=" + name + ", new=" + res);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IPECommands getPECommands(String domain, String user, String password, String cpURI) throws VWException {
        ORBSession oRBSession;
        String m_method = "getPECommands:" + cpURI + "," + user;
        logger.entering(m_className, m_method);
        try {
            block9: {
                if (cpURI == null) throw new VWException("orb.session.missingConnectionPoint", "Missing connection point information.");
                if (cpURI.trim().length() == 0) {
                    throw new VWException("orb.session.missingConnectionPoint", "Missing connection point information.");
                }
                String lcCPURI = cpURI.toLowerCase();
                if (lcCPURI.startsWith("http")) {
                    SOAPClientSession sOAPClientSession;
                    try {
                        VWSOAPRouterURL soapURL = new VWSOAPRouterURL(cpURI);
                        String token = user;
                        if (user != null && password != null) {
                            VWTokenHelper.setUseNewFormat(true);
                            token = VWTokenHelper.GetToken(user, password, null, soapURL.getRouterName());
                            VWTokenHelper.setUseNewFormat(false);
                        }
                        SOAPClientSession soapClient = new SOAPClientSession(token, soapURL);
                        if (logger.isFinest()) {
                            logger.finest(m_className, m_method, "Use SOAP:" + token);
                        }
                        sOAPClientSession = soapClient;
                    }
                    catch (Exception e) {
                        // empty catch block
                        break block9;
                    }
                    Object var11_12 = null;
                    logger.exiting(m_className, m_method);
                    return sOAPClientSession;
                }
            }
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "Try ORB");
            }
            oRBSession = new ORBSession(cpURI, user, password, domain);
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            logger.exiting(m_className, m_method);
            throw throwable;
        }
        Object var11_13 = null;
        logger.exiting(m_className, m_method);
        return oRBSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IPECommands getPECommandsFromURL(String url) throws VWException {
        String m_method = "getPECommandsFromURL:" + url;
        logger.entering(m_className, m_method);
        try {
            ORBSession oRBSession = new ORBSession(url);
            Object var4_3 = null;
            logger.exiting(m_className, m_method);
            return oRBSession;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            logger.exiting(m_className, m_method);
            throw throwable;
        }
    }
}

